<?php
require_once '../includes/auth.php';
checkStaff();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Upload
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['upload_result'])) {
    check_csrf();
    $patient_id = clean_input($_POST['patient_id']);
    $test_name = clean_input($_POST['test_name']);
    
    // File Upload
    $target_dir = "../uploads/";
    $file_name = time() . '_' . basename($_FILES["result_file"]["name"]);
    $target_file = $target_dir . $file_name;
    $uploadOk = 1;
    $imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));

    // Check file size (max 5MB)
    if ($_FILES["result_file"]["size"] > 5000000) {
        $message = '<div class="alert alert-danger">Sorry, your file is too large.</div>';
        $uploadOk = 0;
    }

    // Allow certain file formats
    if($imageFileType != "pdf" ) {
        $message = '<div class="alert alert-danger">Sorry, only PDF files are allowed.</div>';
        $uploadOk = 0;
    }

    if ($uploadOk == 1) {
        if (move_uploaded_file($_FILES["result_file"]["tmp_name"], $target_file)) {
            $stmt = $pdo->prepare("INSERT INTO lab_tests (patient_id, test_name, result_file, status) VALUES (?, ?, ?, 'completed')");
            if ($stmt->execute([$patient_id, $test_name, $file_name])) {
                $message = '<div class="alert alert-success">Lab result uploaded successfully!</div>';
            } else {
                $message = '<div class="alert alert-danger">Database error.</div>';
            }
        } else {
            $message = '<div class="alert alert-danger">Sorry, there was an error uploading your file.</div>';
        }
    }
}

// Fetch Patients
$patients = $pdo->query("SELECT p.id, u.name, u.email FROM patients p JOIN users u ON p.user_id = u.id")->fetchAll();

// Fetch Recent Results
$results = $pdo->query("SELECT l.*, u.name as patient_name FROM lab_tests l JOIN patients p ON l.patient_id = p.id JOIN users u ON p.user_id = u.id ORDER BY l.created_at DESC LIMIT 10")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="lab.php" class="list-group-item list-group-item-action active">Laboratory</a>
            <a href="billing.php" class="list-group-item list-group-item-action">Billing</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Laboratory Management</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Upload Lab Result</div>
            <div class="card-body">
                <form method="POST" action="" enctype="multipart/form-data">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Select Patient</label>
                        <select name="patient_id" class="form-control" required>
                            <option value="">Select Patient</option>
                            <?php foreach($patients as $pat): ?>
                                <option value="<?php echo $pat['id']; ?>"><?php echo htmlspecialchars($pat['name']); ?> (<?php echo htmlspecialchars($pat['email']); ?>)</option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Test Name</label>
                        <input type="text" name="test_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Result File (PDF only)</label>
                        <input type="file" name="result_file" class="form-control" required accept=".pdf">
                    </div>
                    <button type="submit" name="upload_result" class="btn btn-primary">Upload Result</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Recent Lab Results</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Patient</th>
                            <th>Test Name</th>
                            <th>Status</th>
                            <th>File</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($results as $res): ?>
                        <tr>
                            <td><?php echo $res['created_at']; ?></td>
                            <td><?php echo htmlspecialchars($res['patient_name']); ?></td>
                            <td><?php echo htmlspecialchars($res['test_name']); ?></td>
                            <td><span class="badge bg-success"><?php echo ucfirst($res['status']); ?></span></td>
                            <td><a href="../uploads/<?php echo $res['result_file']; ?>" target="_blank" class="btn btn-sm btn-info">View</a></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
