<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

// Fetch Prescriptions
$sql = "SELECT p.*, u.name as doctor_name 
        FROM prescriptions p 
        JOIN doctors d ON p.doctor_id = d.id 
        JOIN users u ON d.user_id = u.id 
        WHERE p.patient_id = ? 
        ORDER BY p.created_at DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$patient_id]);
$prescriptions = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action active">Prescriptions</a>
            <a href="lab_results.php" class="list-group-item list-group-item-action">Lab Results</a>
            <a href="invoices.php" class="list-group-item list-group-item-action">Invoices</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Prescriptions</h2>
        <?php if(count($prescriptions) > 0): ?>
            <?php foreach($prescriptions as $pres): ?>
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Prescription by Dr. <?php echo htmlspecialchars($pres['doctor_name']); ?> on <?php echo $pres['created_at']; ?></span>
                    <button class="btn btn-sm btn-secondary" onclick="printPrescription(<?php echo $pres['id']; ?>)">Print</button>
                </div>
                <div class="card-body">
                    <h5 class="card-title">Medicines</h5>
                    <p class="card-text"><?php echo nl2br(htmlspecialchars($pres['medicines'])); ?></p>
                    <h5 class="card-title">Instructions</h5>
                    <p class="card-text"><?php echo nl2br(htmlspecialchars($pres['instructions'])); ?></p>
                </div>
            </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-info">No prescriptions found.</div>
        <?php endif; ?>
    </div>
</div>

<script>
function printPrescription(id) {
    var printWindow = window.open('print_prescription.php?id=' + id, 'Print', 'width=800,height=600');
    printWindow.onload = function() {
        printWindow.print();
    }
}
</script>

<?php include '../includes/footer.php'; ?>
