<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

// Fetch Invoices
$stmt = $pdo->prepare("SELECT * FROM invoices WHERE patient_id = ? ORDER BY created_at DESC");
$stmt->execute([$patient_id]);
$invoices = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="lab_results.php" class="list-group-item list-group-item-action">Lab Results</a>
            <a href="invoices.php" class="list-group-item list-group-item-action active">Invoices</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Invoices</h2>
        <?php if(count($invoices) > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Description</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invoices as $inv): ?>
                    <tr>
                        <td><?php echo $inv['created_at']; ?></td>
                        <td><?php echo htmlspecialchars($inv['description']); ?></td>
                        <td>$<?php echo number_format($inv['amount'], 2); ?></td>
                        <td>
                            <span class="badge bg-<?php echo $inv['status'] == 'paid' ? 'success' : 'danger'; ?>">
                                <?php echo ucfirst($inv['status']); ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-info">No invoices found.</div>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
