<?php
require_once '../includes/auth.php';
checkPatient();
require_once '../includes/db.php';
include '../includes/header.php';

$user_id = $_SESSION['user_id'];

// Get Patient ID
$stmt = $pdo->prepare("SELECT id FROM patients WHERE user_id = ?");
$stmt->execute([$user_id]);
$patient = $stmt->fetch();
$patient_id = $patient['id'];

// Fetch Upcoming Appointments
$sql = "SELECT a.*, u.name as doctor_name, d.specialization 
        FROM appointments a 
        JOIN doctors d ON a.doctor_id = d.id 
        JOIN users u ON d.user_id = u.id 
        WHERE a.patient_id = ? AND a.appointment_date >= CURDATE() 
        ORDER BY a.appointment_date ASC LIMIT 5";
$stmt = $pdo->prepare($sql);
$stmt->execute([$patient_id]);
$appointments = $stmt->fetchAll();
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action active">Dashboard</a>
            <a href="book-appointment.php" class="list-group-item list-group-item-action">Book Appointment</a>
            <a href="appointments.php" class="list-group-item list-group-item-action">My Appointments</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="lab_results.php" class="list-group-item list-group-item-action">Lab Results</a>
            <a href="invoices.php" class="list-group-item list-group-item-action">Invoices</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Patient Dashboard</h2>
        <div class="card mb-4">
            <div class="card-body">
                <h5 class="card-title">Welcome, <?php echo htmlspecialchars($_SESSION['name']); ?>!</h5>
                <p class="card-text">You can book appointments and view your medical history here.</p>
                <a href="book-appointment.php" class="btn btn-primary">Book New Appointment</a>
            </div>
        </div>

        <h3>Upcoming Appointments</h3>
        <?php if(count($appointments) > 0): ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Time</th>
                        <th>Doctor</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($appointments as $app): ?>
                    <tr>
                        <td><?php echo $app['appointment_date']; ?></td>
                        <td><?php echo $app['appointment_time']; ?></td>
                        <td>Dr. <?php echo htmlspecialchars($app['doctor_name']); ?></td>
                        <td>
                            <span class="badge bg-<?php echo $app['status'] == 'confirmed' ? 'success' : ($app['status'] == 'pending' ? 'warning' : 'secondary'); ?>">
                                <?php echo ucfirst($app['status']); ?>
                            </span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No upcoming appointments.</p>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
