<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo defined('APP_NAME') ? APP_NAME : 'HMS'; ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="<?php echo BASE_URL; ?>assets/css/style.css" rel="stylesheet">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container">
        <a class="navbar-brand" href="<?php echo BASE_URL; ?>index.php">HMS</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <?php if(isset($_SESSION['user_id'])): ?>
                    <li class="nav-item">
                        <span class="nav-link text-white">Welcome, <?php echo htmlspecialchars($_SESSION['name']); ?></span>
                    </li>
                    <?php if($_SESSION['role'] == 'admin'): ?>
                        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>admin/index.php">Dashboard</a></li>
                    <?php elseif($_SESSION['role'] == 'doctor'): ?>
                        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>doctor/index.php">Dashboard</a></li>
                    <?php elseif($_SESSION['role'] == 'patient'): ?>
                        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>patient/index.php">Dashboard</a></li>
                    <?php elseif($_SESSION['role'] == 'staff'): ?>
                        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>staff/index.php">Dashboard</a></li>
                    <?php endif; ?>
                    <li class="nav-item">
                        <a class="nav-link btn btn-danger btn-sm text-white ms-2" href="<?php echo BASE_URL; ?>logout.php">Logout</a>
                    </li>
                <?php else: ?>
                    <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>login.php">Login</a></li>
                    <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>register.php">Register</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<div class="container mt-4">
