<?php
session_start();
require_once 'functions.php';

// Check if user is logged in
function checkLogin() {
    if (!isLoggedIn()) {
        redirect('../login.php');
    }
}

// Check if user is admin
function checkAdmin() {
    checkLogin();
    if (!isAdmin()) {
        // Redirect to appropriate dashboard based on role
        if (isDoctor()) redirect('../doctor/index.php');
        if (isPatient()) redirect('../patient/index.php');
        if (isStaff()) redirect('../staff/index.php');
    }
}

// Check if user is doctor
function checkDoctor() {
    checkLogin();
    if (!isDoctor()) {
        redirect('../login.php');
    }
}

// Check if user is patient
function checkPatient() {
    checkLogin();
    if (!isPatient()) {
        redirect('../login.php');
    }
}

// Check if user is staff
function checkStaff() {
    checkLogin();
    if (!isStaff()) {
        redirect('../login.php');
    }
}
?>
