<?php
require_once '../includes/auth.php';
checkDoctor();
require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];

// Get Doctor ID
$stmt = $pdo->prepare("SELECT id FROM doctors WHERE user_id = ?");
$stmt->execute([$user_id]);
$doctor = $stmt->fetch();
$doctor_id = $doctor['id'];

// Handle Status Update
if (isset($_GET['action']) && isset($_GET['id'])) {
    $action = $_GET['action']; // confirm, complete, cancel
    $app_id = $_GET['id'];
    $new_status = '';

    if ($action == 'confirm') $new_status = 'confirmed';
    if ($action == 'complete') $new_status = 'completed';
    if ($action == 'cancel') $new_status = 'cancelled';

    if ($new_status) {
        $stmt = $pdo->prepare("UPDATE appointments SET status = ? WHERE id = ? AND doctor_id = ?");
        $stmt->execute([$new_status, $app_id, $doctor_id]);
        header("Location: index.php");
        exit();
    }
}

// Fetch Appointments
$sql = "SELECT a.*, u.name as patient_name, p.gender, p.phone 
        FROM appointments a 
        JOIN patients p ON a.patient_id = p.id 
        JOIN users u ON p.user_id = u.id 
        WHERE a.doctor_id = ? 
        ORDER BY a.appointment_date ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$doctor_id]);
$appointments = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action active">Dashboard</a>
            <a href="medical_records.php" class="list-group-item list-group-item-action">Medical Records</a>
            <a href="prescriptions.php" class="list-group-item list-group-item-action">Prescriptions</a>
            <a href="profile.php" class="list-group-item list-group-item-action">Update Profile</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Doctor Dashboard</h2>
        
        <div class="card">
            <div class="card-header">My Appointments</div>
            <div class="card-body">
                <?php if(count($appointments) > 0): ?>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Patient</th>
                                <th>Reason</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($appointments as $app): ?>
                            <tr>
                                <td><?php echo $app['appointment_date']; ?></td>
                                <td><?php echo $app['appointment_time']; ?></td>
                                <td><?php echo htmlspecialchars($app['patient_name']); ?></td>
                                <td><?php echo htmlspecialchars($app['reason']); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $app['status'] == 'confirmed' ? 'success' : ($app['status'] == 'pending' ? 'warning' : 'secondary'); ?>">
                                        <?php echo ucfirst($app['status']); ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if($app['status'] == 'pending'): ?>
                                        <a href="?action=confirm&id=<?php echo $app['id']; ?>" class="btn btn-success btn-sm">Confirm</a>
                                        <a href="?action=cancel&id=<?php echo $app['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Cancel appointment?')">Cancel</a>
                                    <?php elseif($app['status'] == 'confirmed'): ?>
                                        <a href="?action=complete&id=<?php echo $app['id']; ?>" class="btn btn-primary btn-sm">Complete</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php else: ?>
                    <p>No appointments assigned.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
