<?php
require_once '../includes/auth.php';
checkAdmin();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Add Doctor
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_doctor'])) {
    check_csrf();
    $name = clean_input($_POST['name']);
    $email = clean_input($_POST['email']);
    $password = $_POST['password'];
    $phone = clean_input($_POST['phone']);
    $department_id = clean_input($_POST['department_id']);
    $specialization = clean_input($_POST['specialization']);

    if (!empty($name) && !empty($email) && !empty($password)) {
        // Check email
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);
        if ($stmt->rowCount() > 0) {
            $message = '<div class="alert alert-danger">Email already exists.</div>';
        } else {
            try {
                $pdo->beginTransaction();

                // Create User
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, 'doctor')");
                $stmt->execute([$name, $email, $hashed_password]);
                $user_id = $pdo->lastInsertId();

                // Create Doctor Profile
                $stmt = $pdo->prepare("INSERT INTO doctors (user_id, department_id, specialization, phone) VALUES (?, ?, ?, ?)");
                $stmt->execute([$user_id, $department_id, $specialization, $phone]);

                $pdo->commit();
                $message = '<div class="alert alert-success">Doctor added successfully!</div>';
            } catch (Exception $e) {
                $pdo->rollBack();
                $message = '<div class="alert alert-danger">Error adding doctor: ' . $e->getMessage() . '</div>';
            }
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill all required fields.</div>';
    }
}

// Fetch Doctors
$sql = "SELECT d.*, u.name, u.email, dept.name as dept_name 
        FROM doctors d 
        JOIN users u ON d.user_id = u.id 
        JOIN departments dept ON d.department_id = dept.id 
        ORDER BY d.id DESC";
$doctors = $pdo->query($sql)->fetchAll();

// Fetch Departments for Dropdown
$departments = $pdo->query("SELECT * FROM departments")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="doctors.php" class="list-group-item list-group-item-action active">Manage Doctors</a>
            <a href="departments.php" class="list-group-item list-group-item-action">Manage Departments</a>
            <a href="beds.php" class="list-group-item list-group-item-action">Manage Beds</a>
            <a href="admissions.php" class="list-group-item list-group-item-action">IPD Admissions</a>
            <a href="pharmacy.php" class="list-group-item list-group-item-action">Pharmacy</a>
            <a href="reports.php" class="list-group-item list-group-item-action">Reports</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Manage Doctors</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Add New Doctor</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Doctor Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Phone</label>
                        <input type="text" name="phone" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Department</label>
                        <select name="department_id" class="form-control" required>
                            <option value="">Select Department</option>
                            <?php foreach($departments as $dept): ?>
                                <option value="<?php echo $dept['id']; ?>"><?php echo htmlspecialchars($dept['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Specialization</label>
                        <input type="text" name="specialization" class="form-control">
                    </div>
                    <button type="submit" name="add_doctor" class="btn btn-primary">Add Doctor</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Existing Doctors</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Department</th>
                            <th>Specialization</th>
                            <th>Phone</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($doctors as $doc): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($doc['name']); ?></td>
                            <td><?php echo htmlspecialchars($doc['email']); ?></td>
                            <td><?php echo htmlspecialchars($doc['dept_name']); ?></td>
                            <td><?php echo htmlspecialchars($doc['specialization']); ?></td>
                            <td><?php echo htmlspecialchars($doc['phone']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
