<?php
require_once '../includes/auth.php';
checkAdmin();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Add Department
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_department'])) {
    check_csrf();
    $name = clean_input($_POST['name']);
    $description = clean_input($_POST['description']);

    if (!empty($name)) {
        $stmt = $pdo->prepare("INSERT INTO departments (name, description) VALUES (?, ?)");
        if ($stmt->execute([$name, $description])) {
            $message = '<div class="alert alert-success">Department added successfully!</div>';
        } else {
            $message = '<div class="alert alert-danger">Error adding department.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Department name is required.</div>';
    }
}

// Handle Delete Department
if (isset($_GET['delete'])) {
    $id = clean_input($_GET['delete']);
    $stmt = $pdo->prepare("DELETE FROM departments WHERE id = ?");
    if ($stmt->execute([$id])) {
        $message = '<div class="alert alert-success">Department deleted successfully!</div>';
    } else {
        $message = '<div class="alert alert-danger">Error deleting department.</div>';
    }
}

// Fetch Departments
$departments = $pdo->query("SELECT * FROM departments ORDER BY id DESC")->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="doctors.php" class="list-group-item list-group-item-action">Manage Doctors</a>
            <a href="departments.php" class="list-group-item list-group-item-action active">Manage Departments</a>
            <a href="beds.php" class="list-group-item list-group-item-action">Manage Beds</a>
            <a href="admissions.php" class="list-group-item list-group-item-action">IPD Admissions</a>
            <a href="pharmacy.php" class="list-group-item list-group-item-action">Pharmacy</a>
            <a href="reports.php" class="list-group-item list-group-item-action">Reports</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Manage Departments</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Add New Department</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="mb-3">
                        <label>Department Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Description</label>
                        <textarea name="description" class="form-control"></textarea>
                    </div>
                    <button type="submit" name="add_department" class="btn btn-primary">Add Department</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Existing Departments</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($departments as $dept): ?>
                        <tr>
                            <td><?php echo $dept['id']; ?></td>
                            <td><?php echo htmlspecialchars($dept['name']); ?></td>
                            <td><?php echo htmlspecialchars($dept['description']); ?></td>
                            <td>
                                <a href="?delete=<?php echo $dept['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
