<?php
require_once '../includes/auth.php';
checkAdmin();
require_once '../includes/db.php';

$message = '';
$csrf_token = generateCSRFToken();

// Handle Admission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['admit_patient'])) {
    check_csrf();
    $patient_id = clean_input($_POST['patient_id']);
    $bed_id = clean_input($_POST['bed_id']);
    $admission_date = clean_input($_POST['admission_date']);

    if (!empty($patient_id) && !empty($bed_id) && !empty($admission_date)) {
        try {
            $pdo->beginTransaction();

            // Insert Admission
            $stmt = $pdo->prepare("INSERT INTO ipd_admissions (patient_id, bed_id, admission_date, status) VALUES (?, ?, ?, 'admitted')");
            $stmt->execute([$patient_id, $bed_id, $admission_date]);

            // Update Bed Status
            $stmt = $pdo->prepare("UPDATE beds SET is_occupied = 1 WHERE id = ?");
            $stmt->execute([$bed_id]);

            $pdo->commit();
            $message = '<div class="alert alert-success">Patient admitted successfully!</div>';
        } catch (Exception $e) {
            $pdo->rollBack();
            $message = '<div class="alert alert-danger">Error admitting patient.</div>';
        }
    } else {
        $message = '<div class="alert alert-danger">Please fill all fields.</div>';
    }
}

// Handle Discharge
if (isset($_GET['discharge'])) {
    $admission_id = clean_input($_GET['discharge']);
    $bed_id = clean_input($_GET['bed_id']);
    
    try {
        $pdo->beginTransaction();

        // Update Admission
        $stmt = $pdo->prepare("UPDATE ipd_admissions SET status = 'discharged', discharge_date = CURDATE() WHERE id = ?");
        $stmt->execute([$admission_id]);

        // Free Bed
        $stmt = $pdo->prepare("UPDATE beds SET is_occupied = 0 WHERE id = ?");
        $stmt->execute([$bed_id]);

        $pdo->commit();
        $message = '<div class="alert alert-success">Patient discharged successfully!</div>';
    } catch (Exception $e) {
        $pdo->rollBack();
        $message = '<div class="alert alert-danger">Error discharging patient.</div>';
    }
}

// Fetch Patients
$patients = $pdo->query("SELECT p.id, u.name, u.email FROM patients p JOIN users u ON p.user_id = u.id")->fetchAll();

// Fetch Available Beds
$available_beds = $pdo->query("SELECT * FROM beds WHERE is_occupied = 0")->fetchAll();

// Fetch Active Admissions
$sql = "SELECT a.*, u.name as patient_name, b.bed_number, b.type 
        FROM ipd_admissions a 
        JOIN patients p ON a.patient_id = p.id 
        JOIN users u ON p.user_id = u.id 
        JOIN beds b ON a.bed_id = b.id 
        WHERE a.status = 'admitted' 
        ORDER BY a.admission_date DESC";
$admissions = $pdo->query($sql)->fetchAll();

include '../includes/header.php';
?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="index.php" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="doctors.php" class="list-group-item list-group-item-action">Manage Doctors</a>
            <a href="departments.php" class="list-group-item list-group-item-action">Manage Departments</a>
            <a href="beds.php" class="list-group-item list-group-item-action">Manage Beds</a>
            <a href="admissions.php" class="list-group-item list-group-item-action active">IPD Admissions</a>
            <a href="pharmacy.php" class="list-group-item list-group-item-action">Pharmacy</a>
            <a href="reports.php" class="list-group-item list-group-item-action">Reports</a>
            <a href="../logout.php" class="list-group-item list-group-item-action text-danger">Logout</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>IPD Admissions</h2>
        <?php echo $message; ?>

        <div class="card mb-4">
            <div class="card-header">Admit Patient</div>
            <div class="card-body">
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>Select Patient</label>
                            <select name="patient_id" class="form-control" required>
                                <option value="">Select Patient</option>
                                <?php foreach($patients as $pat): ?>
                                    <option value="<?php echo $pat['id']; ?>"><?php echo htmlspecialchars($pat['name']); ?> (<?php echo htmlspecialchars($pat['email']); ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Select Bed</label>
                            <select name="bed_id" class="form-control" required>
                                <option value="">Select Bed</option>
                                <?php foreach($available_beds as $bed): ?>
                                    <option value="<?php echo $bed['id']; ?>"><?php echo htmlspecialchars($bed['bed_number']); ?> (<?php echo htmlspecialchars($bed['type']); ?> - $<?php echo $bed['price']; ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Admission Date</label>
                            <input type="date" name="admission_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                        </div>
                    </div>
                    <button type="submit" name="admit_patient" class="btn btn-primary">Admit Patient</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">Active Admissions</div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Admission Date</th>
                            <th>Patient</th>
                            <th>Bed</th>
                            <th>Type</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($admissions as $adm): ?>
                        <tr>
                            <td><?php echo $adm['admission_date']; ?></td>
                            <td><?php echo htmlspecialchars($adm['patient_name']); ?></td>
                            <td><?php echo htmlspecialchars($adm['bed_number']); ?></td>
                            <td><?php echo htmlspecialchars($adm['type']); ?></td>
                            <td>
                                <a href="?discharge=<?php echo $adm['id']; ?>&bed_id=<?php echo $adm['bed_id']; ?>" class="btn btn-warning btn-sm" onclick="return confirm('Discharge patient?')">Discharge</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
